* MTABaggregaton_topcoding.do: Creates top-coding indicators for expenditure aggregates.

#delim;

gen	totalexpT	    = (COST_=="T") if 	/*	1	TOTALEXP	Average annual expenditures	*/
UCC==	2120	|
UCC>=	190901	& UCC<= 220322 |
UCC>=	220901	& UCC<= 450110 |
UCC==	450210	|
UCC==	450220	|
UCC>=	450310	& UCC<= 450414 |
UCC==	460110	|
UCC>=	460901	& UCC<= 460902 |
UCC>=	470111	& UCC<= 600122 |
UCC>=	600131	& UCC<= 600132 |
UCC>=	600141	& UCC<= 600142 |
UCC>=	600210	& UCC<= 710110 |
UCC>=	790220	& UCC<= 790600 |
UCC==	790690	|
UCC==	800111	|
UCC==	800121	|
UCC>=	800700	& UCC<= 800710 |
UCC==	800801	|
UCC>=	800804	& UCC<= 800940 |
UCC==	850300	|
UCC==	880110	|
UCC==	880210	|
UCC==	880310	|
UCC>=	900001	& UCC<= 900002 |
UCC>=	990900	& UCC<= 990940

; gen 	foodhomeT	= (COST_=="T") if 	/*	3	FOODHOME	Food at home*/
UCC==	190904	|	/*	4	190904	Food prepared by consumer unit on out-of-town trips	*/
                    /*		790210	Total purchases at grocery stores (Note: This is not a primary expenditure)*/
UCC==	790220	|	/*	4	790220	Grocery stores (thru Q20071)*/
UCC==	790230	|	/*	4	790230	Convenience stores (thru Q20071)*/
UCC==	790240		/*	4	790240	Food and non alcoholic beverages (new UCC Q20072)*/
							
; gen 	foodawayT	= (COST_=="T") if 	/*	3	FOODAWAY	Food away from home	*/
UCC==	190901	|	/*	4	190901	Food or board at school	*/
UCC==	190902	|	/*	4	190902	Catered affairs	*/
UCC==	190903	|	/*	4	190903	Food on out-of-town trips*/
UCC==	790410	|	/*	4	790410	Meals at restaurants; carry-outs and other	*/
UCC== 	790430		/*	4	790430	School lunches	*/
							
; gen 	mealaspayT	= (COST_=="T") if 	/*		MEALASPAY	Meals as pay	*/
UCC==	800700		/*	4	800700	Meals as pay*/
							
; gen 	alchomeT	= (COST_=="T") if 	/*	3	ALCHOME	Alcoholic beverages consumed at home	*/
UCC==	790310	|	/*	4	790310	Beer and wine (thru Q20071)	*/
UCC==	790320	|	/*	4	790320	Other alcoholic beverages (thru Q20071)	*/
UCC==	790330		/*	4	790330	Beer; wine; other alcohol (new UCC Q20072) (Note:790330=790310+790320)*/
							
; gen 	alcawayT	= (COST_=="T") if 	/*	3	ALCAWAY	Away from home	*/
UCC==	790420	|	/*	4	790420	Alcoholic beverages at restaurants; taverns	*/
UCC==	200900		/*	4	200900	Alcoholic beverages purchased on trips	*/
                    /*	2	HOUSING	Housing	*/
                    /*	3	SHELTER	Shelter	*/
                    /*	4	OWNDWELL	Owned dwellings	*/
							
; gen 	mortgageintT	= (COST_=="T") if 	/*		MORTGAGEINT	Mortgage interest expenses	*/
UCC==	220311	|	/*	6	220311	Mortgage interest	*/
UCC==	220312	|	/*	7	220312	Mortgage interest (vacation homes) 	*/
UCC==	220313	|	/*	6	220313	Interest paid; home equity loan	*/
UCC==	220314	|	/*	7	220314	Interest paid; home equity loan (vacation homes)	*/
UCC==	220321	|	/*	6	220321	Prepayment penalty charges (thru Q20071)	*/
UCC==	220322	|	/*	7	220322	Prepayment penalty charge (vacation homes) (thru Q20071)	*/
UCC==	880110	|	/*	6	880110	Interest paid; home equity line of credit	*/
UCC==	880210	|	/*	3	880210	Interest paid; home equity line of credit (other property)	*/
UCC==	880310		/*	7	880310	Interest paid; home equity line of credit (vacation homes)	*/
							
; gen 	proptaxT	= (COST_=="T") if 	/*		PROPTAX	Property taxes	*/
UCC==	220211	|	/*	5	220211	Property taxes	*/
UCC==	220212		/*	6	220212	Property taxes (vacation homes) 	*/
							
; gen 	houseexpST	= (COST_=="T") if 	/*		HOUSEEXPS	House expenditures (services)	*/
			/*	5	OWNEXPEN	Maintenance; repairs; insurance; other expenses	*/
UCC==	210901	|	/*	6	210901	Ground rent	*/
UCC==	210902	|	/*	7	210902	Ground rent (vacation homes)	*/
UCC==	220111	|	/*		220111	Fire and extended coverage for owned homes is now included under UCC 220121 (HOMEOWNERS INSURANCE OWND). (deleted 99)	*/
UCC==	220112	|	/*		220112	Fire and extended coverage for owned vacation homes is now included under UCC 220122 (HOMEOWNERS INSURANCE OWNV). (vacation homes) (deleted 99)	*/
UCC==	220121	|	/*	6	220121	Homeowners insurance	*/
UCC==	220122	|	/*	7	220122	Homeowners insurance (vacation homes)	*/
			/*	6	OWNREPSV	Maintenance and repair services	*/
UCC==	230112	|	/*	7	230112	Painting and papering	*/
UCC==	230113	|	/*	7	230113	Plumbing and water heating	*/
UCC==	230114	|	/*	7	230114	Heat; a/c; electrical work	*/
UCC==	230115	|	/*	7	230115	Roofing and gutters	*/
UCC==	230116	|	/*		230116	Contractors' labor and material costs, owned home (these data, except for termite and pest control, are now being mapped to 230151) (deleted 94)	*/
UCC==	230119	|	/*		230119	Same as 230116 - owned vacation home, vacation condos and co-ops (these data, except for termite and pest control, are now being mapped to 230152) (deleted 94)	*/
UCC==	230122	|	/*	7	230122	Repair and replacement of hard surface flooring	*/
UCC==	230123	|	/*	8	230123	Repair and replacement of hard surface flooring (vacation homes)	*/
UCC==	230142	|	/*	7	230142	Repair of built-in appliances	*/
UCC==	230151	|	/*	7	230151	Other repair and maintenance services	*/
UCC==	230152	|	/*	8	230152	Repair and remodeling services (vacation homes)	*/
			/*	6	OWNMNAGE	Property management and security	*/
UCC==	220901	|	/*	6	220901	Parking	*/
UCC==	220902	|	/*	7	220902	Parking (vacation homes)	*/
UCC==	230901	|	/*	7	230901	Property management	*/
UCC==	230902	|	/*	8	230902	Property management (vacation homes)	*/
UCC==	340911	|	/*	7	340911	Management and upkeep services for security	*/
UCC==	340912	|	/*	8	340912	Management and upkeep services for security (vacation homes)	*/
UCC==	790600		/*	3	790600	Expenses for other properties (vacation homes)	*/
							
; gen 	houseexpDT	= (COST_=="T") if 	/*		HOUSEEXPD	House expenditures (durables)	*/
			/*	6	OWNREPSP	Maintenance and repair commodities	*/
UCC==	240112	|	/*	7	240112	Paints; wallpaper and supplies	*/
UCC==	240113	|	/*	8	240113	Paints; wallpaper; supplies (vacation homes)	*/
UCC==	240122	|	/*	7	240122	Tools and equipment for painting and wallpapering	*/
UCC==	240123	|	/*	8	240123	Tools and equipment for painting and wallpapering (vacation homes)	*/
UCC==	240212	|	/*	7	240212	Materials for plaster.; panel.; siding; windows; doors; screens; awnings	*/
UCC==	240213	|	/*	7	240213	Materials and equipment for roof and gutters	*/
UCC==	240214	|	/*	8	240214	Materials for plastering; paneling; roofing; gutters; downspouts; siding; windows; doors; screens; and awnings (vacation homes)	*/
UCC==	240222	|	/*	7	240222	Materials for patio; walk; fence; driveway;masonry; brick and stucco work	*/
UCC==	240223	|	/*	8	240223	Material for patio; walk; fence; drive;masonry; brick; stucco (vacation homes)	*/
UCC==	240312	|	/*	7	240312	Plumbing supplies and equipment	*/
UCC==	240313	|	/*	8	240313	Plumbing supplies and equipment (vacation homes)	*/
UCC==	240322	|	/*	7	240322	Electrical supplies; heating and cooling equipment	*/
UCC==	240323	|	/*	8	240323	Electrical supplies; heating and cooling equipment (vacation homes)	*/
UCC==	320622	|	/*	7	320622	Materials for hard surface flooring; repair and replacement	*/
UCC==	320623	|	/*	8	320623	Materials for hard surface flooring (vacation homes)	*/
UCC==	320632	|	/*	7	320632	Materials for landscaping maintenance	*/
UCC==	320633	|	/*	8	320633	Materials for landscaping maintenance (vacation homes)	*/
			/*	7	OWNMISC	Miscellaneous supplies and equipment	*/
UCC==	320612	|	/*	8	320612	Material for insulation; other maintenance and repair	*/
UCC==	320613	|	/*	9	320613	Material for insulation; other maintenance and repair (vacation homes)	*/
UCC==	990930	|	/*	8	990930	Materials to finish basement; remodel rooms or build patios; walks; etc. (maint.; repair and repl. - owned properties)	*/
UCC==	990940		/*	9	990940	Material for finishing basements and remodeling rooms (vacation homes)	*/
							
; gen 	houseawayT	= (COST_=="T") if 	/*		HOUSEAWAY	Housing away	*/
UCC==	210210	|	/*	5	210210	Lodging on out-of-town trips	*/
UCC==	210310		/*	5	210310	Housing while attending school	*/
							
; gen 	rentpaidT	= (COST_=="T") if 	/*		RENTPAID	Rent paid	*/
UCC==	210110		/*	5	210110	Rent	*/
							
; gen 	rentaspayT	= (COST_=="T") if 	/*		RENTASPAY	Rent as pay  	*/
UCC==	800710		/*	5	800710	Rent as pay (Note: I assume that the employer pays the CUs rent; but this is probably NOT income from renting an appartment!)	*/
							
; gen 	rentalexpST	= (COST_=="T") if 	/*		RENTALEXPS	rental expenditures (services)	*/
			/*	5	RNTEXPEN	Maintenance; insurance and other expenses	*/
UCC==	350110	|	/*	6	350110	Tenant's insurance	*/
			/*	6	RNTREPSV	Maintenance and repair services	*/
UCC==	230111	|	/*	7	230111	Contractors' labor and material costs, renter (these data, except for termite and pest control, are now being mapped to 230150) (deleted 94)	*/
UCC==	230121	|	/*	7	230121	Repair and replacement of hard surface flooring	*/
UCC==	230141	|	/*	7	230141	Repair of built-in appliances	*/
UCC==	230150		/*	7	230150	Repair or maintenance services	*/
							
; gen 	rentalexpDT	= (COST_=="T") if 	/*		RENTALEXPD	rental expenditures (durables)	*/
			/*	6	RNTREPSP	Maintenance and repair commodities	*/
UCC==	240111	|	/*	7	240111	Paint; wallpaper; and supplies	*/
UCC==	240121	|	/*	7	240121	Tools and equipment for painting and wallpapering	*/
UCC==	240211	|	/*	7	240211	Materials for plastering; panels; roofing;gutters; etc.	*/
UCC==	240221	|	/*	7	240221	Materials for patio; walk; fence; driveway;masonry; brick and stucco work	*/
UCC==	240311	|	/*	7	240311	Plumbing supplies and equipment	*/
UCC==	240321	|	/*	7	240321	Electrical supplies; heating and cooling equipment	*/
			/*	7	RNTMISC	Miscellaneous supplies and equipment	*/
UCC==	320611	|	/*	8	320611	Material for insulation; other maintenance and repair	*/
UCC==	320621	|	/*	7	320621	Material for hard surface flooring	*/
UCC==	320631	|	/*	7	320631	Material for landscape maintenance	*/
UCC==	790690	|	/*	8	790690	Construction materials for jobs not started	*/
UCC==	990920		/*	8	990920	Materials for additions; finishing basements;remodeling rooms	*/
							
; gen 	energyT	= (COST_=="T") if 	/*		ENERGY	Energy	*/
			/*	4	NATRLGAS	Natural gas	*/
UCC==	260211	|	/*	5	260211	Utility--natural gas (renter)	*/
UCC==	260212	|	/*	5	260212	Utility--natural gas (owned home)	*/
UCC==	260213	|	/*	5	260213	Utility--natural gas (owned vacation)	*/
UCC==	260214	|	/*	5	260214	Utility--natural gas (rented vacation)	*/
			/*	4	ELECTRIC	Electricity	*/
UCC==	260111	|	/*	5	260111	Electricity (renter)	*/
UCC==	260112	|	/*	5	260112	Electricity (owned home)	*/
UCC==	260113	|	/*	5	260113	Electricity (owned vacation)	*/
UCC==	260114	|	/*	5	260114	Electricity (rented vacation)	*/
			/*	4	OTHRFUEL	Fuel oil and other fuels	*/
			/*	5	FUELOIL	Fuel oil	*/
UCC==	250111	|	/*	6	250111	Fuel oil (renter)	*/
UCC==	250112	|	/*	6	250112	Fuel oil (owned home)	*/
UCC==	250113	|	/*	6	250113	Fuel oil (owned vacation)	*/
UCC==	250114	|	/*	6	250114	Fuel oil (rented vacation)	*/
			/*	5	BOTTLGAS	Bottled gas	*/
UCC==	250211	|	/*	6	250211	Gas; btld/tank (renter)	*/
UCC==	250212	|	/*	6	250212	Gas; btld/tank (owned home)	*/
UCC==	250213	|	/*	6	250213	Gas; btld/tank (owned vacation)	*/
UCC==	250214	|	/*	6	250214	Gas; btld/tank (rented vacation)	*/
			/*	5	CLWDOTFL	Coal; wood; and other fuels	*/
UCC==	250221	|	/*	6	250221	Coal - renter (deleted 05)	*/
UCC==	250222	|	/*	6	250222	Coal - owned dwelling (deleted 05)	*/
UCC==	250223	|	/*	6	250223	Coal - owned vacation property (deleted 05)	*/
UCC==	250224	|	/*	6	250224	Coal - rented vacation property (deleted 05)	*/
UCC==	250901	|	/*	6	250901	Wood/ Kerosene/ Other fuels - renter (deleted 05)	*/
UCC==	250902	|	/*	6	250902	Wood/ Kerosene/ Other fuels - owned dwelling (deleted 05)	*/
UCC==	250903	|	/*	6	250903	Wood/ Kerosene/ Other fuels - owned vacation property (deleted 05)	*/
UCC==	250904	|	/*	6	250904	Wood/ Kerosene/ Other fuels - rented vacation property (deleted 05)	*/
UCC==	250911	|	/*	6	250911	Coal; wood; other fuels (renter) [2005Q2] 	*/
UCC==	250912	|	/*	6	250912	Coal; wood; other fuels (owned home) [2005Q2]	*/
UCC==	250913	|	/*	6	250913	Coal; wood; other fuels (owned vacation) [2005Q2]	*/
UCC==	250914		/*	6	250914	Coal; wood; other fuels (rented vacation) [2005Q2]	*/
							
; gen 	phoneT	= (COST_=="T") if 	/*	4	PHONE	Telephone services	*/
UCC==	270000	|	/*	5	270000	Telephone service, incl. public pay phones (deleted 91)	*/
UCC==	270101	|	/*	5	270101	Residential telephone/pay phones [1991Q2] 	*/
UCC==	270102	|	/*	5	270102	Cellular phone service  [1993Q2]	*/
UCC==	270103	|	/*	5	270103	Pager service (2001-2006)	*/
UCC==	270104	|	/*	5	270104	Phone cards (2001Q2)	*/
UCC==	270105		/*	5	270105	Voice over IP service (new UCC Q20072)	*/
							
; gen 	waterT	= (COST_=="T") if 	/*	4	WATER	Water and other public services	*/
			/*	5	SEWER	Water and sewerage maintenance	*/
UCC==	270211	|	/*	6	270211	Water/sewer maint. (renter)	*/
UCC==	270212	|	/*	6	270212	Water/sewer maint. (owned home)	*/
UCC==	270213	|	/*	6	270213	Water/sewer maint. (owned vacation)	*/
UCC==	270214	|	/*	6	270214	Water/sewer maint. (rented vacation)	*/
			/*	5	TRASH	Trash and garbage collection	*/
UCC==	270411	|	/*	6	270411	Trash/garb. coll. (renter)	*/
UCC==	270412	|	/*	6	270412	Trash/garb. coll. (owned home)	*/
UCC==	270413	|	/*	6	270413	Trash/garb. coll. (owned vacation)	*/
UCC==	270414	|	/*	6	270414	Trash/garb. coll. (rented vacation)	*/
			/*	5	SEPTANK	Septic tank cleaning	*/
UCC==	270901	|	/*	6	270901	Septic tank clean. (renter)	*/
UCC==	270902	|	/*	6	270902	Septic tank clean. (owned home)	*/
UCC==	270903	|	/*	6	270903	Septic tank clean. (owned vacation)	*/
UCC==	270904		/*	6	270904	Septic tank clean. (rented vacation)	*/
							
; gen 	babysitT	= (COST_=="T") if 	/*		BABYSIT	Babysitting  	*/
UCC==	340210	|	/*		340210	Babysitting (deleted 93)	*/
UCC==	340211	|	/*	5	340211	Babysitting and child care in your own home (1993Q2)	*/
UCC==	340212	|	/*	5	340212	Babysitting and child care in someone else's home (1993Q2)	*/
UCC==	670310		/*	5	670310	Day care centers; nursery; and preschools	*/
							
; gen 	elderlyT	= (COST_=="T") if 	/*		ELDERLY	Elderly care	*/
UCC==	340906	|	/*	5	340906	Care for elderly; invalids; handicapped; etc.	*/
UCC==	340910		/*	5	340910	Adult day care centers	*/
							
; gen 	householdT	= (COST_=="T") if 	/*		HOUSEHOLD	Household related expenses	*/
			/*	4	HHOTHXPN	Other household expenses	*/
UCC==	330511	|	/*	5	330511	Termite/pest control products	*/
UCC==	340310	|	/*	5	340310	Housekeeping services	*/
UCC==	340410	|	/*	5	340410	Gardening; lawn care service	*/
UCC==	340420	|	/*	5	340420	Water softening service	*/
UCC==	340510	|	/*	5	340510	Moving; storage; freight	*/
UCC==	340520	|	/*	5	340520	Household laundry and dry cleaning; sent out (non-clothing) not coin-operated	*/
UCC==	340530	|	/*	5	340530	Coin-operated household laundry and dry cleaning (non-clothing)	*/
UCC==	340620	|	/*	5	340620	Appliance repair; including service center	*/
UCC==	340630	|	/*	5	340630	Reupholstering; furniture repair	*/
UCC==	340901	|	/*	5	340901	Repairs/rentals of lawn and garden equipment; hand or power tools; other household equipment	*/
UCC==	340903	|	/*	5	340903	Other home services	*/
UCC==	340907	|	/*	5	340907	Appliance rental	*/
UCC==	340908	|	/*	5	340908	Rental of office equipment for non-business use	*/
UCC==	340914	|	/*	5	340914	Services for termite/pest control	*/
UCC==	340915	|	/*	5	340915	Home security system service fee	*/
UCC==	690113	|	/*	5	690113	Repair of computer systems for non-business use	*/
UCC==	690114	|	/*	5	690114	Computer information services	*/
UCC==	690310	|	/*	5	690310	Installation of computer (new UCC Q20072)	*/
UCC==	990900	|	/*	5	990900	Rental and installation of dishwashers; range hoods;and garbage disposals	*/
UCC==	990910		/*		990910	Materials for termite and pest control are no longer collected as a capital improvement (Section 5B). This item is now included in UCC 330511 (deleted 99)	*/
							
; gen 	furnitureT	= (COST_=="T") if 	/*		FURNITURE	Furniture 	*/
			/*	4	HHTXTILE	Household textiles	*/
UCC==	280110	|	/*	5	280110	Bathroom linens	*/
UCC==	280120	|	/*	5	280120	Bedroom linens	*/
UCC==	280130	|	/*	5	280130	Kitchen and dining room linens	*/
UCC==	280210	|	/*	5	280210	Curtains and draperies	*/
UCC==	280220	|	/*	5	280220	Slipcovers; decorative pillows	*/
UCC==	280230	|	/*	5	280230	Sewing materials for slipcovers; curtains; other sewing materials for the home	*/
UCC==	280900	|	/*	5	280900	Other linens	*/
			/*	4	FURNITUR	Furniture	*/
UCC==	290110	|	/*	5	290110	Mattress and springs	*/
UCC==	290120	|	/*	5	290120	Other bedroom furniture	*/
UCC==	290210	|	/*	5	290210	Sofas	*/
UCC==	290310	|	/*	5	290310	Living room chairs	*/
UCC==	290320	|	/*	5	290320	Living room tables	*/
UCC==	290410	|	/*	5	290410	Kitchen; dining room furniture	*/
UCC==	290420	|	/*	5	290420	Infants' furniture	*/
UCC==	290430	|	/*	5	290430	Outdoor furniture	*/
UCC==	290440	|	/*	5	290440	Wall units; cabinets and other occasional furniture	*/
			/*	4	FLOORCOV	Floor coverings	*/
UCC==	230131	|	/*	5	230131	Installed Wall-to-Wall Carpeting - Renter  (deleted 99)	*/
UCC==	230132	|	/*	5	230132	Wall-to-wall carpet installed replacement owned is now included in newly added UCC 230133 (deleted 99)	*/
UCC==	230133	|	/*	5	230133	Wall-to-wall carpet (replacement) (owned home)	*/
UCC==	230134	|	/*	6	230134	Wall-to-wall carpet (renter)	*/
UCC==	320110	|	/*	5	320110	Non-permanent floor coverings is now included in newly added UCC 320111 (deleted 99)	*/
UCC==	320111	|	/*	5	320111	Floor coverings; non-permanent	*/
UCC==	320161	|	/*	5	320161	Non-Installed Wall to Wall Carpeting and Carpet Squares - Renter  (deleted 99)	*/
UCC==	320162	|	/*	5	320162	Non-Installed Wall-to-Wall Carpeting (Replacement) and Carpet Squares - Homeowner  (deleted 99)	*/
UCC==	320163	|	/*	6	320163	Wall-to-wall carpet (replacement)(renter) [1999]	*/
			/*	4	MAJAPPL	Major appliances	*/
UCC==	230117	|	/*	5	230117	Dishwashers (built-in); garbage disposals; range hoods; (renter)	*/
UCC==	230118	|	/*	5	230118	Dishwashers (built-in); garbage disposals; range hoods; (owned home)	*/
UCC==	300111	|	/*	5	300111	Refrigerators; freezers (renter)	*/
UCC==	300112	|	/*	5	300112	Refrigerators; freezers (owned home)	*/
UCC==	300211	|	/*	5	300211	Washing machines (renter)	*/
UCC==	300212	|	/*	5	300212	Washing machines (owned home)	*/
UCC==	300221	|	/*	5	300221	Clothes dryers (renter)	*/
UCC==	300222	|	/*	5	300222	Clothes dryers (owned home)	*/
UCC==	300311	|	/*	5	300311	Cooking stoves; ovens (renter)	*/
UCC==	300312	|	/*	5	300312	Cooking stoves; ovens (owned home)	*/
UCC==	300321	|	/*	5	300321	Microwave ovens (renter)	*/
UCC==	300322	|	/*	5	300322	Microwave ovens (owned home)	*/
UCC==	300331	|	/*	5	300331	Portable dishwasher (renter)	*/
UCC==	300332	|	/*	5	300332	Portable dishwasher (owned home)	*/
UCC==	300411	|	/*	5	300411	Window air conditioners (renter)	*/
UCC==	300412	|	/*	5	300412	Window air conditioners (owned home)	*/
UCC==	320511	|	/*	5	320511	Electric floor cleaning equipment	*/
UCC==	320512	|	/*	5	320512	Sewing machines	*/
			/*	4	SMAPPHWR	Small appliances; miscellaneous housewares	*/
UCC==	320310	|	/*	6	320310	Plastic dinnerware	*/
UCC==	320320	|	/*	6	320320	China and other dinnerware	*/
UCC==	320330	|	/*	6	320330	Flatware	*/
UCC==	320340	|	/*	6	320340	Glassware	*/
UCC==	320350	|	/*	6	320350	Silver serving pieces	*/
UCC==	320360	|	/*	6	320360	Other serving pieces	*/
UCC==	320370	|	/*	6	320370	Nonelectric cookware	*/
UCC==	320521	|	/*	6	320521	Small electric kitchen appliances	*/
UCC==	320522	|	/*	6	320522	Portable heating and cooling equipment	*/
			/*	4	MISCHHEQ	Miscellaneous household equipment	*/
UCC==	320120	|	/*	5	320120	Window coverings	*/
UCC==	320130	|	/*	5	320130	Infants' equipment	*/
UCC==	320150	|	/*	5	320150	Outdoor equipment	*/
UCC==	320210	|	/*	5	320210	Clocks (thru Q20071)	*/
UCC==	320220	|	/*	5	320220	Lamps and lighting fixtures	*/
UCC==	320230	|	/*	5	320230	Other Household Decorative Items (deleted 81)	*/
UCC==	320231	|	/*	5	320231	Other household decorative items (thru Q20071)	*/
UCC==	320232	|	/*	5	320232	Telephones and accessories	*/
UCC==	320233	|	/*	5	320233	Clocks and other household decorative items (new UCC Q20072)	*/
UCC==	320410	|	/*	5	320410	Lawn and garden equipment	*/
UCC==	320420	|	/*	5	320420	Power tools	*/
UCC==	320901	|	/*	5	320901	Office furniture for home use	*/
UCC==	320902	|	/*	5	320902	Hand tools	*/
UCC==	320903	|	/*	5	320903	Indoor plants; fresh flowers	*/
UCC==	320904	|	/*	5	320904	Closet and storage items	*/
UCC==	340904	|	/*	5	340904	Rental of furniture	*/
UCC==	430130	|	/*	5	430130	Luggage	*/
UCC==	690110	|	/*	5	690110	Computers for Non-Business Use (Not in 90,91,92)  (1982-1987)	*/
UCC==	690111	|	/*	5	690111	Computers and computer hardware for non-business use [1988]	*/
UCC==	690112	|	/*	5	690112	Computer software and accessories for non-business use [1988]	*/
UCC==	690115	|	/*	5	690115	Personal digital assistants [2005]	*/
UCC==	690116	|	/*	5	690116	Internet services away from home [2005]	*/
UCC==	690210	|	/*	5	690210	Telephone answering devices	*/
UCC==	690220	|	/*	5	690220	Calculators (deleted 05)	*/
UCC==	690230	|	/*	5	690230	Business equipment for home use	*/
UCC==	690241	|	/*	5	690241	Smoke alarms (renter)	*/
UCC==	690242	|	/*	5	690242	Smoke alarms (owned home)	*/
UCC==	690243	|	/*	5	690243	Smoke alarms (owned vacation)	*/
UCC==	690244	|	/*	5	690244	Other household appliances (renter)	*/
UCC==	690245		/*	5	690245	Other household appliances (owned home)	*/
							
; gen 	clothDT	= (COST_=="T") if 	/*		CLOTH	Clothing (durables)	*/
			/*	4	MENS	Men; 16 and over	*/
UCC==	360110	|	/*	5	360110	Men's suits	*/
UCC==	360120	|	/*	5	360120	Men's sportcoats; tailored jackets	*/
UCC==	360210	|	/*	5	360210	Men's coats and jackets	*/
UCC==	360311	|	/*	5	360311	Men's underwear	*/
UCC==	360312	|	/*	5	360312	Men's hosiery	*/
UCC==	360320	|	/*	5	360320	Men's nightwear	*/
UCC==	360330	|	/*	5	360330	Men's accessories	*/
UCC==	360340	|	/*	5	360340	Men's sweaters and vests	*/
UCC==	360350	|	/*	5	360350	Men's active sportswear	*/
UCC==	360410	|	/*	5	360410	Men's shirts	*/
UCC==	360511	|	/*	5	360511	Men's pants (thru Q20071)	*/
UCC==	360512	|	/*	5	360512	Men's shorts; shorts sets (thru Q20071)	*/
UCC==	360513	|	/*	5	360513	Men's pants and shorts (new UCC Q20072)	*/
UCC==	360901	|	/*	5	360901	Men's uniforms	*/
UCC==	360902	|	/*	5	360902	Men's costumes	*/
			/*	4	BOYS	Boys; 2 to 15	*/
UCC==	370110	|	/*	5	370110	Boys' coats and jackets	*/
UCC==	370120	|	/*	5	370120	Boys' sweaters	*/
UCC==	370130	|	/*	5	370130	Boys' shirts	*/
UCC==	370211	|	/*	5	370211	Boys' underwear	*/
UCC==	370212	|	/*	5	370212	Boys' nightwear	*/
UCC==	370213	|	/*	5	370213	Boys' hosiery	*/
UCC==	370220	|	/*	5	370220	Boys' accessories	*/
UCC==	370311	|	/*	5	370311	Boys' suits; sportcoats; vests	*/
UCC==	370312	|	/*	5	370312	Boys' pants (thru Q20071)	*/
UCC==	370313	|	/*	5	370313	Boys' shorts; shorts sets (thru Q20071)	*/
UCC==	370314	|	/*	5	370314	Boys' pants and shorts (new UCC Q20072)	*/
UCC==	370901	|	/*		370901	Boy's uniforms, active sports wear (split into two new UCC's - 370903 and 370904) (deleted 95)	*/
UCC==	370902	|	/*	5	370902	Boys' costumes	*/
UCC==	370903	|	/*	5	370903	Boys' uniforms	*/
UCC==	370904	|	/*	5	370904	Boys' active sportswear	*/
			/*	4	WOMENS	Women; 16 and over	*/
UCC==	380110	|	/*	5	380110	Women's coats and jackets	*/
UCC==	380210	|	/*	5	380210	Women's dresses	*/
UCC==	380311	|	/*	5	380311	Women's sportcoats; tailored jackets	*/
UCC==	380312	|	/*	5	380312	Women's vests and sweaters	*/
UCC==	380313	|	/*	5	380313	Women's shirts; tops; blouses	*/
UCC==	380320	|	/*	5	380320	Women's skirts	*/
UCC==	380331	|	/*	5	380331	Women's pants (thru Q20071)	*/
UCC==	380332	|	/*	5	380332	Women's shorts; shorts sets (thru Q20071)	*/
UCC==	380333	|	/*	5	380333	Women's pants and shorts (new UCC Q20072)	*/
UCC==	380340	|	/*	5	380340	Women's active sportswear	*/
UCC==	380410	|	/*	5	380410	Women's sleepwear	*/
UCC==	380420	|	/*	5	380420	Women's undergarments	*/
UCC==	380430	|	/*	5	380430	Women's hosiery	*/
UCC==	380510	|	/*	5	380510	Women's suits	*/
UCC==	380901	|	/*	5	380901	Women's accessories	*/
UCC==	380902	|	/*	5	380902	Women's uniforms	*/
UCC==	380903	|	/*	5	380903	Women's costumes	*/
			/*	4	GIRLS	Girls; 2 to 15	*/
UCC==	390110	|	/*	5	390110	Girls' coats and jackets	*/
UCC==	390120	|	/*	5	390120	Girls' dresses and suits	*/
UCC==	390210	|	/*	5	390210	Girls' shirts; blouses; sweaters	*/
UCC==	390221	|	/*	5	390221	Girls' skirts and pants (thru Q20071)	*/
UCC==	390222	|	/*	5	390222	Girls' shorts; shorts sets (thru Q20071)	*/
UCC==	390223	|	/*	5	390223	Girls' skirts; pants; and shorts (new UCC Q20072)	*/
UCC==	390230	|	/*	5	390230	Girls' active sportswear	*/
UCC==	390310	|	/*	5	390310	Girls' underwear and sleepwear	*/
UCC==	390321	|	/*	5	390321	Girls' hosiery	*/
UCC==	390322	|	/*	5	390322	Girls' accessories	*/
UCC==	390901	|	/*	5	390901	Girls' uniforms	*/
UCC==	390902	|	/*	5	390902	Girls' costumes	*/
			/*	3	INFANT	Children under 2	*/
UCC==	410110	|	/*	4	410110	Infant coat; jacket; snowsuit	*/
UCC==	410111	|	/*	4	410111	Infant Coats, Jackets, and Snowsuits 9B (deleted 91Q2)	*/
UCC==	410112	|	/*	4	410112	Infant Coats, Jackets, and Snowsuits 9A (deleted 91Q2)	*/
UCC==	410120	|	/*	4	410120	Infant dresses; outerwear	*/
UCC==	410121	|	/*	4	410121	Infant Dresses and Outerwear 9B (deleted 91Q2)	*/
UCC==	410122	|	/*	4	410122	Infant Dresses and Outerwear 9A (deleted 91Q2)	*/
UCC==	410130	|	/*	4	410130	Infant underwear	*/
UCC==	410131	|	/*	4	410131	Infant Undergarments 9B, Including Diapers (deleted 91Q2)	*/
UCC==	410132	|	/*	4	410132	Infant Undergarments 9A, Including Diapers (deleted 91Q2)	*/
UCC==	410140	|	/*	4	410140	Infant nightwear; loungewear	*/
UCC==	410141	|	/*	4	410141	Infant Sleeping Garments 9B (deleted 91Q2)	*/
UCC==	410142	|	/*	4	410142	Infant Sleeping Garments 9A (deleted 91Q2)	*/
UCC==	410901	|	/*	4	410901	Infant accessories	*/
UCC==	410902	|	/*	4	410902	Infants' other clothing (deleted 91)	*/
UCC==	410903	|	/*	4	410903	Infant Accessories 9A (deleted 91Q2)	*/
UCC==	410904	|	/*	4	410904	Infant Hosiery, Footwear, and Other Clothing (deleted 91Q2)	*/
			/*	3	FOOTWEAR	Footwear	*/
UCC==	400110	|	/*	4	400110	Men's footwear	*/
UCC==	400210	|	/*	4	400210	Boys' footwear	*/
UCC==	400220	|	/*	4	400220	Girls' footwear	*/
UCC==	400310	|	/*	4	400310	Women's footwear	*/
			/*	3	OTHAPPRL	Other apparel products	*/
UCC==	420110	|	/*	4	420110	Material for making clothes	*/
UCC==	420120		/*	4	420120	Sewing patterns and notions	*/
							
; gen 	clothST	= (COST_=="T") if 	/*		CLOTH	Clothing (services)	*/
			/*	3	OTHAPPRL	Other apparel products and services	*/
UCC==	440110	|	/*	4	440110	Shoe repair and other shoe service	*/
UCC==	440120	|	/*	4	440120	Coin-operated apparel laundry and dry cleaning	*/
UCC==	440130	|	/*	4	440130	Alteration; repair and tailoring of apparel and accessories	*/
UCC==	440140	|	/*	4	440140	Clothing rental	*/
UCC==	440150	|	/*	4	440150	Watch and jewelry repair	*/
UCC==	440210	|	/*	4	440210	Apparel laundry and dry cleaning not coin-operated	*/
UCC==	440900		/*	4	440900	Clothing storage	*/
							
; gen 	jewelryT	= (COST_=="T") if 	/*		JEWELRY	Jewelry	*/
UCC==	430110	|	/*	4	430110	Watches	*/
UCC==	430120		/*	4	430120	Jewelry	*/
							
; gen 	vehpurchT	= (COST_=="T") if 	/*	3	VEHPURCH	Vehicle purchases (net outlay)	*/
			/*	4	NEWCARS	Cars and trucks; new	*/
UCC==	450110	|	/*	5	450110	New cars	*/
			/*	5	450116	Trade-In Allowance For New Cars (deleted) [Note: (1) "trade-in allowance"=A reduction in the price of a new item when an old item is given as part of the deal. (2) Since the vehicle purchases are already 'net outlays' we do not have to substract the trade-in allowances.]	*/
UCC==	450210	|	/*	5	450210	New trucks	*/
			/*	5	450216	Trade-In Allowance For New Trucks or Vans (deleted)	*/
			/*	4	USEDCARS	Cars and trucks; used	*/
UCC==	460110	|	/*	5	460110	Used cars	*/
			/*	5	460116	Trade-In Allowance For Used Cars (deleted)	*/
UCC==	460901	|	/*	5	460901	Used trucks	*/
			/*	5	460907	Trade-In Allowance For Used Trucks or Vans (deleted)	*/
			/*	4	OTHVEHCL	Other vehicles	*/
UCC==	450220	|	/*	5	450220	New motorcycles	*/
			/*	5	450226	Trade-In Allowance For New Motorcycles, Motor Scooters, or Mopeds (deleted)	*/
UCC==	450900	|	/*	5	450900	New aircraft (deleted 82/3)	*/
			/*	5	450906	Trade-In allowance new airplanes (deleted 82/3)	*/
UCC==	460902	|	/*	5	460902	Used motorcycles	*/
			/*	5	460908	Trade-In Allowance For Used Motorcycles, Motor Scooters, or Mopeds (deleted)	*/
UCC==	460903		/*	5	460903	Used aircraft (deleted 82/3)	*/
			/*	5	460909	Trade-In allowance used airplanes (deleted 82/3)	*/
							
; gen 	gasolineT	= (COST_=="T") if 	/*		GASOLINE	Gasoline	*/
			/*	3	GASOIL	Gasoline and motor oil	*/
UCC==	470111	|	/*	4	470111	Gasoline	*/
UCC==	470112	|	/*	4	470112	Diesel fuel	*/
UCC==	470113	|	/*	4	470113	Gasoline on out-of-town trips	*/
UCC==	470211	|	/*	4	470211	Motor oil	*/
UCC==	470212		/*	4	470212	Motor oil on out-of-town trips	*/
							
; gen 	vehexpDT	= (COST_=="T") if 	/*		VEHEXPD	Vehicle expenditures (durables)	*/
			/*	4	CAREPAIR	Maintenance and repairs	*/
UCC==	470220	|	/*	5	470220	Coolant; brake fluid; transmission fluid; and other additives	*/
UCC==	480110	|	/*	5	480110	Tires - purchased; replaced; installed	*/
UCC==	480211	|	/*	5	480211	Battery replacement  audio equipment, floormats, seatcovers, other accessories, batteries, other vehicle equipment installed by CU (split into two new UCC's - 480213 and 480214) (deleted 94)	*/
UCC==	480212	|	/*	5	480212	Vehicle products and cleaning services	*/
UCC==	480213	|	/*	5	480213	Parts; equipment; and accessories	*/
UCC==	480214	|	/*	5	480214	Vehicle audio equipment	*/
UCC==	480215		/*	5	480215	Vehicle video equipment	*/
							
; gen 	vehexpST	= (COST_=="T") if 	/*		VEHEXPS	Vehicle expenditures (services)	*/
			/*	4	CAREPAIR	Maintenance and repairs	*/
UCC==	490110	|	/*	5	490110	Body work and painting	*/
UCC==	490211	|	/*	5	490211	Clutch; transmission repair	*/
UCC==	490212	|	/*	5	490212	Drive shaft and rear-end repair	*/
UCC==	490220	|	/*	5	490220	Brake work (490220 and 490315 are now collapsed and collected under 490221) (deleted 95)	*/
UCC==	490221	|	/*	5	490221	Brake work; including adjustments	*/
UCC==	490231	|	/*	5	490231	Repair to steering or front-end	*/
UCC==	490232	|	/*	5	490232	Repair to engine cooling system	*/
UCC==	490311	|	/*	5	490311	Motor tune-up	*/
UCC==	490312	|	/*	5	490312	Lube; oil change; and oil filters	*/
UCC==	490313	|	/*	5	490313	Front-end alignment; wheel balance and rotation	*/
UCC==	490314	|	/*	5	490314	Shock absorber replacement	*/
UCC==	490315	|	/*	5	490315	Brake adjustment (490220 and 490315 are now collapsed and collected under 490221) (deleted 95)	*/
UCC==	490317	|	/*	5	490317	Minor vehicle repairs and service out-of-town trips (deleted 91)	*/
UCC==	490318	|	/*	5	490318	Repair tires and other repair work	*/
UCC==	490319	|	/*	5	490319	Vehicle air conditioning repair	*/
UCC==	490411	|	/*	5	490411	Exhaust system repair	*/
UCC==	490412	|	/*	5	490412	Electrical system repair	*/
UCC==	490413	|	/*	5	490413	Motor repair; replacement	*/
UCC==	490500	|	/*	5	490500	Purchase and installation of vehicle accessories, incl audio equipment, customizing, and items such as luggage racks, fog lamps, and trailer hitches (split into two new UCC's - 490501 and 490502) (deleted 94)	*/
UCC==	490501	|	/*	5	490501	Vehicle accessories including labor	*/
UCC==	490502	|	/*	5	490502	Vehicle audio equipment including labor (thru Q20051)	*/
UCC==	490900	|	/*	5	490900	Auto repair service policy	*/
			/*		VEHINS		*/
UCC==	500110	|	/*	4	500110	Vehicle insurance	*/
			/*	4	VEHFINCH	Vehicle finance charges	*/
UCC==	510110	|	/*	5	510110	Automobile finance charges	*/
UCC==	510901	|	/*	5	510901	Truck finance charges	*/
UCC==	510902	|	/*	5	510902	Motorcycle and plane finance charges	*/
UCC==	850300	|	/*	5	850300	Other vehicle finance charges	*/
			/*	6	RENTVEH	Rented vehicles	*/
UCC==	520511	|	/*	7	520511	Auto rental	*/
UCC==	520512	|	/*	7	520512	Auto rental; out-of-town trips	*/
UCC==	520521	|	/*	7	520521	Truck rental	*/
UCC==	520522	|	/*	7	520522	Truck rental; out-of-town trips	*/
UCC==	520902	|	/*	7	520902	Motorcycle rental	*/
UCC==	520903	|	/*	7	520903	Aircraft rental	*/
UCC==	520905	|	/*	7	520905	Motorcycle rental; out-of-town trips	*/
UCC==	520906	|	/*	7	520906	Aircraft rental, out of town trips (deleted 06)	*/
			/*	6	LEASVEH	Leased vehicles	*/
UCC==	450310	|	/*	7	450310	Car lease payments	*/
UCC==	450311	|	/*	7	450311	Charges Other Than Basic Lease, Such as Insurance or Maintenance (Car Lease) (deleted)	*/
			/*	7	450312	Trade-In Allowance (Car Lease) (deleted)	*/
UCC==	450313	|	/*	7	450313	Cash down-payment (car lease)	*/
UCC==	450314	|	/*	7	450314	Termination fee (car lease)	*/
UCC==	450410	|	/*	7	450410	Truck lease payments	*/
UCC==	450411	|	/*	7	450411	Charges Other Than Basic Lease, Such as Insurance or Maintenance (Truck/Van Lease) (deleted)	*/
			/*	7	450412	Trade-In Allowance (Truck/Van Lease) (deleted)	*/
UCC==	450413	|	/*	7	450413	Cash down-payment (truck lease)	*/
UCC==	450414	|	/*	7	450414	Termination fee (truck lease)	*/
UCC==	520110	|	/*	5	520110	State or local vehicle registration	*/
UCC==	520111	|	/*	5	520111	State vehicle registration (deleted 06)	*/
UCC==	520112	|	/*	5	520112	Local vehicle registration (deleted 06)	*/
UCC==	520310	|	/*	5	520310	Drivers' license	*/
UCC==	520410	|	/*	5	520410	Vehicle inspection	*/
			/*	5	PARKING	Parking fees	*/
UCC==	520530	|	/*	6	520530	Parking fees, incl. garages, meters, lot fees,excl. fees that are costs of property ownership (deleted 91)	*/
UCC==	520531	|	/*	6	520531	Parking fees in home city; excluding residence	*/
UCC==	520532	|	/*	6	520532	Parking fees; out-of-town trips	*/
UCC==	520541	|	/*	5	520541	Tolls or electronic toll passes	*/
UCC==	520542	|	/*	5	520542	Tolls on out-of-town trips	*/
UCC==	520550	|	/*	5	520550	Towing charges	*/
UCC==	520560	|	/*	5	520560	Global positioning services	*/
UCC==	620113		/*	5	620113	Automobile service clubs	*/
							
; gen 	pubtransT	= (COST_=="T") if 	/*	3	PUBTRANS	Public transportation	*/
UCC==	530110	|	/*	4	530110	Airline fares	*/
UCC==	530210	|	/*	4	530210	Intercity bus fares	*/
UCC==	530311	|	/*	4	530311	Intercity mass transit fares	*/
UCC==	530312	|	/*	4	530312	Local trans. on out-of-town trips	*/
UCC==	530411	|	/*	4	530411	Taxi fares and limousine services on trips	*/
UCC==	530412	|	/*	4	530412	Taxi fares and limousine services	*/
UCC==	530510	|	/*	4	530510	Intercity train fares	*/
UCC==	530901	|	/*	4	530901	Ship fares	*/
UCC==	530902		/*	4	530902	School bus	*/
			/*	2	HEALTH	Healthcare	*/
							
; gen 	healthinsT	= (COST_=="T") if 	/*		HEALTHINS	Health insurance	*/
			/*	4	COMHLTIN	Commercial health insurance	*/
UCC==	580110	|	/*	5	580110	Commercial health insurance (split into two new UCCs - 580111 and 580113) (deleted 95)	*/
UCC==	580111	|	/*	5	580111	Traditional fee for service health plan (not BCBS)	*/
UCC==	580113	|	/*	5	580113	Preferred provider health plan (not BCBS)	*/
			/*	4	BCBS	Blue Cross; Blue Shield	*/
UCC==	580112	|	/*	5	580112	Traditional fee for service health plan (BCBS)	*/
UCC==	580114	|	/*	5	580114	Preferred provider health plan (BCBS)	*/
UCC==	580210	|	/*	5	580210	Blue Cross/Blue Shield (divided into new UCCs - 580112, 580114, 580312, 580904,580906) (deleted 95)	*/
UCC==	580310	|	/*	5	580310	Health maintenance plans (now collected under 580311) (deleted 95)	*/
UCC==	580311	|	/*	4	580311	Health maintenance organization (not BCBS)	*/
UCC==	580312	|	/*	5	580312	Health maintenance organization (BCBS)	*/
UCC==	580901	|	/*	4	580901	Medicare payments	*/
UCC==	580904	|	/*	5	580904	Commercial medicare supplement (BCBS)	*/
UCC==	580906	|	/*	5	580906	Other health insurance (BCBS)	*/
UCC==	580907	|	/*	4	580907	Medicare prescription drug premium (new UCC Q20062)	*/
			/*	4	COMEDOTH	Commercial medicare supplements and other health insurance	*/
UCC==	580400	|	/*	4	580400	Long term care insurance	*/
UCC==	580902	|	/*	5	580902	Commercial Medicare supplement and other health insurance (split into two new UCCs - 580903 and 580905) (deleted 95)	*/
UCC==	580903	|	/*	5	580903	Commercial medicare supplement (not BCBS)	*/
UCC==	580905		/*	5	580905	Other health insurance (not BCBS)	*/
							
 			/*		HEALTHEXP		*/
; gen 	healthexpDT	= (COST_=="T") if 	/*		HEALTHEXPD	Health expenditures (durables)	*/
			/*	3	MEDSUPPL	Medical supplies	*/
UCC==	550110	|	/*	4	550110	Eyeglasses and contact lenses	*/
UCC==	550320	|	/*	4	550320	Medical equipment for general use	*/
UCC==	550330	|	/*	4	550330	Supportive and convalescent medical equipment	*/
UCC==	550340		/*	4	550340	Hearing aids	*/
							
; gen 	healthexpST	= (COST_=="T") if 	/*		HEALTHEXPS	Health expenditures (services)	*/
			/*	3	MEDSUPPL	Medical supplies	*/
UCC==	570901	|	/*	4	570901	Rental of medical equipment	*/
UCC==	570903	|	/*	4	570903	Rental of supportive; convalescent medical equipment	*/
			/*	3	MEDSERVS	Medical services	*/
UCC==	540000	|	/*	3	540000	Prescription drugs	*/
UCC==	560110	|	/*	4	560110	Physician's services	*/
UCC==	560210	|	/*	4	560210	Dental services	*/
UCC==	560310	|	/*	4	560310	Eye-care services	*/
UCC==	560320	|	/*	4	560320	Medical services by practitioner other than physician (deleted 91)	*/
UCC==	560330	|	/*	4	560330	Lab tests; x-rays	*/
UCC==	560400	|	/*	4	560400	Service by professionals other than physician	*/
UCC==	560900	|	/*	4	560900	Nursing services and therapeutic treatments (deleted 91)	*/
UCC==	570110	|	/*	4	570110	Hospital room (deleted 05)	*/
UCC==	570111	|	/*	4	570111	Hospital room and services	*/
UCC==	570210	|	/*	4	570210	Hospital service other than room (deleted 05)	*/
UCC==	570220	|	/*	4	570220	Care in convalescent or nursing home	*/
UCC==	570230	|	/*	4	570230	Other medical care services	*/
UCC==	570240		/*	4	570240	Medical care in retirement community	*/
							
; gen 	entertainST	= (COST_=="T") if 	/*		ENTRTAINS	Entertainment (services)	*/
			/*	3	FEESADM	Fees and admissions	*/
UCC==	610900	|	/*	4	610900	Recreation expenses; out-of-town trips	*/
UCC==	620110	|	/*	4	620110	Country clubs, swimming pools, fraternal org. (deleted 92)	*/
UCC==	620111	|	/*	4	620111	Social; recreation; health club membership	*/
UCC==	620121	|	/*	4	620121	Fees for participant sports	*/
UCC==	620122	|	/*	4	620122	Participant sports; out-of-town trips	*/
UCC==	620211	|	/*	4	620211	Movie; theater; amusement parks; and other	*/
UCC==	620212	|	/*	4	620212	Movie; other admissions; out-of-town trips	*/
UCC==	620221	|	/*	4	620221	Admission to sporting events	*/
UCC==	620222	|	/*	4	620222	Admission to sports events; out-of-town trips	*/
UCC==	620310	|	/*	4	620310	Fees for recreational lessons	*/
UCC==	620903	|	/*	4	620903	Other entertainment services; out-of-town trips	*/
UCC==	680904	|	/*	3	680904	Dating services	*/
UCC==	680905	|	/*	3	680905	Vacation clubs (new UCC Q20072)	*/
			/*	3	TVAUDIO	Audio and visual equipment and services	*/
UCC==	270310	|	/*	4	270310	Cable and satellite television services	*/
UCC==	270311	|	/*	4	270311	Satellite radio service (new UCC Q20072)	*/
UCC==	310240	|	/*	4	310240	Streaming; downloading video	*/
UCC==	310341	|	/*	4	310341	Record/tape/CD/video mail order club (deleted 05)	*/
UCC==	310350	|	/*	4	310350	Streaming; downloading audio (2005)	*/
UCC==	340610	|	/*	4	340610	Repair of TV; radio; and sound equipment	*/
UCC==	340902	|	/*	4	340902	Rental of televisions	*/
UCC==	340905	|	/*	4	340905	Rental of VCR; radio; and sound equipment	*/
UCC==	620904	|	/*	4	620904	Rental and repair of musical instruments	*/
UCC==	620912	|	/*	4	620912	Rental of video cassettes; tapes; films; and discs (82)	*/
UCC==	620916	|	/*	4	620916	Rental of computer and video game hardware and software (new UCC Q20072)	*/
UCC==	620926	|	/*	3	620926	Lotteries and pari-mutuel losses	*/
UCC==	620930	|	/*	4	620930	Online gaming services (2005)	*/
UCC==	690320	|	/*	4	690320	Installation of televisions (new UCC Q20072)	*/
UCC==	690330	|	/*	4	690330	Installation of satellite television equipment (new UCC Q20072)	*/
UCC==	690340	|	/*	4	690340	Installation of sound systems (new UCC Q20072)	*/
UCC==	690350	|	/*	4	690350	Installation of other video equipment of sound systems (new UCC Q20072)	*/
			/*	3	PETSPLAY	Pets; toys; hobbies; and playground equipment	*/
UCC==	620410	|	/*	5	620410	Pet services	*/
UCC==	620420	|	/*	5	620420	Vet services	*/
			/*	4	RNTSPVEH	Rental of recreational vehicles	*/
UCC==	520901	|	/*	4	520901	Docking and landing fees	*/
UCC==	520903	|	/*	5	520903	Aircraft rental (deleted 06)	*/
UCC==	520904	|	/*	5	520904	Rental non-camper trailer	*/
UCC==	520906	|	/*	5	520906	Aircraft rental; out-of-town trips	*/
UCC==	520907	|	/*	5	520907	Boat and trailer rental out-of-town trips	*/
UCC==	600110	|	/*	4	600110	Outboard motors	*/
UCC==	620902	|	/*	4	620902	Rental of campers and other vehicles on trips (deleted 91)	*/
UCC==	620906	|	/*	5	620906	Rental of boat	*/
UCC==	620907	|	/*	5	620907	Rental of all campers and other recreational vehicles (not on trip) (split into two new UCC's - 620921 and 620922) (deleted 94)	*/
UCC==	620909	|	/*	5	620909	Rental of campers on out-of-town trips	*/
UCC==	620919	|	/*	5	620919	Rental of other vehicles on out-of-town trips	*/
UCC==	620921	|	/*	5	620921	Rental of motorized camper	*/
UCC==	620922	|	/*	5	620922	Rental of other RV"s	*/
			/*	4	RECEQUIP	Sports; recreation and exercise equipment	*/
UCC==	620908	|	/*	5	620908	Rental and repair of miscellaneous sports equipment	*/
			/*	4	PHOTOEQ	Photographic equipment; supplies and services	*/
UCC==	620320	|	/*	5	620320	Photographer fees	*/
UCC==	620330	|	/*	5	620330	Photo processing	*/
UCC==	620905	|	/*	5	620905	Repair and rental of photographic equipment	*/
UCC==	680310	|	/*	4	680310	Live entertainment for catered affairs (new UCC Q20072)	*/
UCC==	680320		/*	4	680320	Rental of party supplies for catered affairs (new UCC Q20072)	*/
							
; gen 	entertainDT	= (COST_=="T") if 	/*		ENTRTAIND	Entertainment (durables)	*/
			/*	3	TVAUDIO	Audio and visual equipment and services	*/
UCC==	310110	|	/*	4	310110	Black and white TV (deleted 05)	*/
UCC==	310120	|	/*	4	310120	Color RV console (deleted 05)	*/
UCC==	310130	|	/*	4	310130	Color TV portable/ table model (deleted 05)	*/
UCC==	310140	|	/*	4	310140	Televisions	*/
UCC==	310210	|	/*	4	310210	VCR's and video disc players	*/
UCC==	310220	|	/*	4	310220	Video cassettes; tapes; and discs	*/
UCC==	310230	|	/*	4	310230	Video game hardware and software	*/
UCC==	310311	|	/*	4	310311	Radios	*/
UCC==	310312	|	/*	4	310312	PHONOGRAPHS This UCC was deleted as an interview UCC (code 410 from section 6B). Phonograph expenditures recorded in the Interview survey is now included under UCC 310333 (Other sound and video equipment, including accessories). (deleted 99)	*/
UCC==	310313	|	/*	4	310313	Tape recorders and players	*/
UCC==	310314	|	/*	4	310314	Personal digital audio players	*/
UCC==	310320	|	/*	4	310320	Sound components and component systems	*/
UCC==	310330	|	/*	4	310330	Accessories and other sound equipment (deleted 96)	*/
UCC==	310333	|	/*	4	310333	Accessories and other sound equipment	*/
UCC==	310334	|	/*	4	310334	Satellite dishes	*/
UCC==	310340	|	/*	4	310340	CDs; records; audio tapes	*/
UCC==	310342	|	/*	4	310342	Records, CDs, audio tapes, needles (deleted 05)	*/
UCC==	610130	|	/*	4	610130	Musical instruments and accessories	*/
			/*	3	PETSPLAY	Pets; toys; hobbies; and playground equipment	*/
UCC==	610110	|	/*	4	610110	Toys; games; arts and crafts; and tricycles	*/
UCC==	610120	|	/*	4	610120	Playground equipment	*/
UCC==	610140	|	/*	4	610140	Stamp and coin collecting [2004]	*/
UCC==	610320	|	/*	5	610320	Pet purchase; supplies; medicine	*/
			/*	4	UNMTRBOT	Unmotored recreational vehicles	*/
UCC==	600121	|	/*	5	600121	Boat without motor and boat trailers	*/
			/*	5	600127	Trade-In Allowance For Boat Without Motor or Non Camper-Type Trailer,Such as for Boat or Cycle (deleted)	*/
UCC==	600122	|	/*	5	600122	Trailer and other attachable campers	*/
			/*	5	600128	Trade-In Allowance For Trailer-Type or Other Attachable-Type Camper (deleted)	*/
			/*	4	PWRSPVEH	Motorized recreational vehicles	*/
UCC==	600131	|	/*	5	600131	Motorized camper-coach or other vehicles (net outlay) (split into two new UCC's - 600141 and 600142) (deleted 94)	*/
			/*	5	600137	Trade-in allowance for motorized camper-coach or other vehicles (split into two new UCC's - 600143 and 600144) (deleted 94)	*/
UCC==	600132	|	/*	5	600132	Purchase of boat with motor	*/
			/*	5	600138	Trade-In Allowance For Boat With Motor (deleted)	*/
UCC==	600141	|	/*	5	600141	Purchase of motorized camper	*/
			/*	5	600143	Trade-In allowance, motorized camper (deleted)	*/
UCC==	600142	|	/*	5	600142	Purchase of other vehicle	*/
			/*	5	600144	Trade-In allowance, other vehicle (deleted)	*/
			/*	4	RECEQUIP	Sports; recreation and exercise equipment	*/
UCC==	600210	|	/*	5	600210	Athletic gear; game tables; and exercise equipment	*/
UCC==	600310	|	/*	5	600310	Bicycles	*/
UCC==	600410	|	/*	5	600410	Camping equipment	*/
UCC==	600420	|	/*	5	600420	Hunting and fishing equipment	*/
UCC==	600430	|	/*	5	600430	Winter sports equipment	*/
UCC==	600900	|	/*	5	600900	Water and miscellaneous sports equipment (split into two new UCC's - 600901 and 600902) (deleted 94)	*/
UCC==	600901	|	/*	5	600901	Water sports equipment	*/
UCC==	600902	|	/*	5	600902	Other sports equipment	*/
			/*	4	PHOTOEQ	Photographic equipment; supplies and services	*/
UCC==	610210	|	/*	5	610210	Film	*/
UCC==	610230		/*	5	610230	Photographic equipment	*/

			/*	2	PERSCARE	Personal care products and services	*/							
; gen 	perscareDT	= (COST_=="T") if 	/*		PERSCARED	Personal care products and services	*/
UCC==	640130	|	/*	3	640130	Wigs and hairpieces	*/
UCC==	640420		/*	3	640420	Electric personal care appliances	*/
							
; gen 	perscareST	= (COST_=="T") if 	/*		PERSCARES	personal care services	*/
UCC==	650110	|	/*	3	650110	Personal care services for females is now included in newly added UCC 650310 (deleted 99)	*/
UCC==	650210	|	/*	3	650210	Personal care services for males is now included in newly added UCC 650310 (deleted 99)	*/
UCC==	650310	|	/*	3	650310	Personal care services	*/
UCC==	650900		/*	3	650900	The repair and servicing of personal care appliances will no longer be collected in the Interview Survey. (deleted 99)	*/
							
; gen 	readingT	= (COST_=="T") if 	/*	2	READING	Reading	*/
UCC==	590110	|	/*	3	590110	Newspapers-single copy and subscription (split into two new UCC's - 590111 and 590112) (deleted 94)	*/
UCC==	590111	|	/*	3	590111	Newspaper subscriptions (deleted 05)	*/
UCC==	590112	|	/*	3	590112	Newspapers, non-subscription (deleted 05)	*/
UCC==	590210	|	/*	3	590210	Magazines and periodicals-single copy and subscription (split into two new UCC's - 590211 and 590212) (deleted 94)	*/
UCC==	590211	|	/*	3	590211	Magazine subscriptions (deleted 05)	*/
UCC==	590212	|	/*	3	590212	Magazines, non-subscription (deleted 05)	*/
UCC==	590220	|	/*	3	590220	Books thru book clubs	*/
UCC==	590230	|	/*	3	590230	Books not thru book clubs	*/
UCC==	590310	|	/*	3	590310	Newspaper; magazine by subscription (2005)	*/
UCC==	590410	|	/*	3	590410	Newspaper; magazine non-subscription (2005)	*/
UCC==	660310		/*	3	660310	Encyclopedia and other sets of reference books	*/
							
; gen 	educationT	= (COST_=="T") if 	/*		EDUCATION 	*/
UCC==	660110	|	/*	3	660110	School books; supplies; equipment for college	*/
UCC==	660210	|	/*	3	660210	School books; supplies; equipment for elementary; high school	*/
UCC==	660410	|	/*	3	660410	School books; supplies; equipment for vocational and technical schools (new UCC Q20072)	*/
UCC==	660900	|	/*	3	660900	School books; supplies; equipment for day care; nursery;preschool; other (thru Q20061)	*/
UCC==	660901	|	/*	3	660901	School books; supplies; equipment for day care; nursery (new UCC Q20062)	*/
UCC==	660902	|	/*	3	660902	School books; supplies; equipment for other schools (new UCC Q20062)	*/
UCC==	670110	|	/*	3	670110	College tuition	*/
UCC==	670210	|	/*	3	670210	Elementary and high school tuition	*/
UCC==	670410	|	/*	3	670410	Vocational and technical school tuition (new UCC Q20072)	*/
UCC==	670901	|	/*	3	670901	Other schools tuition	*/
UCC==	670902		/*	3	670902	Other school expenses including rentals	*/
							
; gen 	tobaccoT	= (COST_=="T") if 	/*	2	TOBACCO	Tobacco products and smoking supplies	*/
UCC==	630110	|	/*	3	630110	Cigarettes	*/
UCC==	630210		/*	3	630210	Other tobacco products	*/
			/*	2	MISC	Miscellaneous	*/
							
; gen 	occupexpT	= (COST_=="T") if 	/*		OCCUPEXP	Occupational expenses	*/
UCC==	900001	|	/*	3	900001	Occupational expenses such as union dues, tools, uniforms, business or professional association dues, licenses or permits (ITAB)	*/
UCC==	900002		/*	3	900002	Occupational expenses	*/
							
; gen 	feenchrgT	= (COST_=="T") if 	/*		FEENCHRG	Finance and other charges	*/
UCC==	620112	|	/*	3	620112	Credit card memberships	*/
UCC==	620115	|	/*	3	620115	Shopping club membership fees	*/
UCC==	680110	|	/*	3	680110	Legal fees	*/
UCC==	680210	|	/*	3	680210	Safe deposit box rental	*/
UCC==	680220	|	/*	3	680220	Checking accounts; other bank service charges	*/
UCC==	680901	|	/*	3	680901	Cemetery lots; vaults; maintenance fees	*/
UCC==	680140	|	/*	3	680140	Funeral expenses	*/
UCC==	680902	|	/*	3	680902	Accounting fees	*/
UCC==	710110	|	/*	3	710110	Finance charges excluding mortgage and vehicle	*/
UCC==	790840		/*	3	790840	Other charges in sale of other properties (deleted 91)	*/
							
; gen 	lifeinsurT	= (COST_=="T") if 	/*		LIFEINSUR	Life and other personal insurance	*/
UCC==	2120	|	/*	4	2120	Other non-health insurance	*/
UCC==	700110		/*	4	700110	Life; endowment; annuity; other personal insurance	*/
							
; gen 	pensionsT	= (COST_=="T") if 	/*		PENSIONS	Pensions and Social Security	*/
UCC==	800910	|	/*	4	800910	Deductions for government retirement	*/
UCC==	800920	|	/*	4	800920	Deductions for railroad retirement	*/
UCC==	800931	|	/*	4	800931	Deductions for private pensions	*/
UCC==	800932	|	/*	4	800932	Non-payroll deposit to retirement plans	*/
UCC==	800940		/*	4	800940	Deductions for Social Security	*/
							
							
			/*		Non-Consumption Expenditures (i.e. not part of total expenditures)		*/
							
; gen 	cashcontT	= (COST_=="T") if 	/*		CASHCONT	Cash contributions	*/
			/*	2	CASHCONT	(replaces contribution variables on FMLY files starting in 2001Q2)	*/
UCC==	800111	|	/*	3	800111	Alimony expenditures (Sec 19)	*/
UCC==	800121	|	/*	3	800121	Child support expenditures (Sec. 19)	*/
UCC==	800800	|	/*	3	800800	Cash gifts and contributions to non-CU members (deleted 92)	*/
UCC==	800803	|	/*	3	800803	Cash gifts to non-CU members contributions to organizations (deleted 02)	*/
UCC==	800804	|	/*	3	800804	Support for college students (Sec. 19)	*/
UCC==	800811	|	/*	3	800811	Gift to non-CU members of stocks; bonds; and mutual funds	*/
UCC==	800821	|	/*	3	800821	Cash contributions to charities and other organizations	*/
UCC==	800831	|	/*	3	800831	Cash contributions to church; religious organizations	*/
UCC==	800841	|	/*	3	800841	Cash contribution to educational institutions	*/
UCC==	800851	|	/*	3	800851	Cash contribution to political organizations	*/
UCC==	800861		/*	3	800861	Other cash gifts	*/
							
;#delim cr